<?php
define('ACTION_OK', 1);
define('ACTION_FAILED', 2);
define('SERVER_ERROR', 3);

define('FORM_DATA_MISSING', 4);
define('PASSWORDS_NOT_MATCH', 5);

define('INVALID_ID', 6);

define('EMPTY_BASKET', 7);
define('LOGIN_REQUIRED', 8);

include 'mydb.php';

class Portal
{
  private $dbo = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new MyDB($host, $user, $pass, $db);
    $this->dbo->set_charset('utf8');
    if($this->dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $this->dbo->connect_error;
      throw new Exception($msg);
    }
  }
  function getUserInfo()
  {
    if(isset($_SESSION['zalogowany'])){
      $str = "Jesteś zalogowany jako: $_SESSION[zalogowany]. ";
      $str .= "<a href=\"logout.php\">Wylogowanie</a>";
    }
    else{
      $str = "Nie jesteś zalogowany.<br />";
      $str .= "<a href=\"index.php?action=showLoginForm\">Logowanie</a>";
    }
    return $str;
  }
  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["email"]) || !isset($_POST["haslo"])){
      return ACTION_FAILED;
    }
    
    $email = $_POST["email"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów.
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    $userEmailLength = strlen(utf8_decode($email));
    $userPassLength = strlen(utf8_decode($pass));
    
    if($userEmailLength < 6 || $userEmailLength > 200 ||
     $userPassLength < 6 || $userPassLength > 40){
      return ACTION_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach.
    $email = $this->dbo->real_escape_string($email);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT `Id`, `Imię`, `Nazwisko`, `Hasło` ";
    $query .= "FROM Klienci WHERE `Email`='$email'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania.
    if($result->num_rows <> 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników.
      return ACTION_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[3];
      //Wersja bez kodowania haseł.
      //if($pass != $pass_db){
      //Wersja z kodowaniem haseł.
      if(crypt($pass, $pass_db) != $pass_db){
        return ACTION_FAILED;
      }
      else{
        $_SESSION['zalogowany'] = $row[1].' '.$row[2];
        $_SESSION['userId'] = $row[0];
        return ACTION_OK;
      }
    }
  }
  
  function logout()
  {
    if(isset($_SESSION['zalogowany'])){
      unset($_SESSION['zalogowany']);
      unset($_SESSION['userId']);
      /*
      //Jeśli sesja ma być usunięta:
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
      */
    }
  }
  
  function showRegistrationForm()
  {
    $reg = new Registration($this->dbo);
    return $reg->showRegistrationForm();
  }
  function registerUser()
  {
    $reg = new Registration($this->dbo);
    return $reg->registerUser();
  }
  
  function showSearchResult()
  {
    //Określenie warunku dla autora.
    if(isset($_GET['autor']) && $_GET['autor'] != ''){
      //Tu lub po przefiltrowaniu dodatkowa weryfikacja poprawności parametru.
      $autor = filter_input(INPUT_GET, 'autor', 
                            FILTER_SANITIZE_SPECIAL_CHARS);
      $cond1 = " AND Autorzy.`Nazwa` LIKE '%$autor%' ";
    }
    else{
      $cond1 = '';
    }
    
    //Określenie warunku dla tytułu.
    if(isset($_GET['tytul']) && $_GET['tytul'] != ''){
      //Tu lub po przefiltrowaniu dodatkowa weryfikacja poprawności parametru.
      $tytul = filter_input(INPUT_GET, 'tytul', 
                            FILTER_SANITIZE_SPECIAL_CHARS);
      $cond2 = " AND Ksiazki.`Tytuł` LIKE '%$tytul%' ";
    }
    else{
      $cond2 = '';
    }
    
    //Formowanie zapytania.
    $query  = 'SELECT `Tytuł`, GROUP_CONCAT(Autorzy.Nazwa) AS Autor, ';
    $query .= 'ISBN, Wydawnictwa.Nazwa AS Wydawnictwo, Cena, ';
    $query .= 'Ksiazki.Id AS Id ';
    $query .= 'FROM Ksiazki, Wydawnictwa, Autorzy, KsiazkiAutorzy ';
    $query .= 'WHERE Ksiazki.WydawnictwoId = Wydawnictwa.Id AND ';
    $query .= 'KsiazkiAutorzy.`KsiążkaId` = Ksiazki.Id AND ';
    $query .= 'KsiazkiAutorzy.AutorId = Autorzy.Id ';
    $query .= $cond1.$cond2;
    $query .= 'GROUP BY Ksiazki.Id';
    
    //Dalsza cześć metody.
  }
}
?>